const pool  = require("../Utils/db");
const tableNames = require("../Utils/allTableNames");
const moment = require('moment-timezone');
const flTableNames = require("../Utils/allTableNames");
const poolFl = require("../Utils/dbFl");
const { setShiftTimes } = require("../Utils/sharedShiftTimes");

// let shiftTimes=[];

const cloneRecordCenterline = async (req, res) => {
    let shiftTime = ""
    let shiftFrequency = ""

    const karachiTime1 = moment().tz('Asia/Karachi');
    const currentTime1 = karachiTime1.format('HH:mm');
    
    const getShiftTimes = () => {
        return new Promise((resolve, reject) => {
            poolFl.getConnection((err, flconnection) => {
                if (err) {
                    console.log("Error getting connection from poolFl:",err);
                    return reject(err);
                } else {
                    flconnection.query(`SELECT * FROM  ${tableNames.frequency} Where frequency like 'S%' and  ? = STR_TO_DATE(shiftTime, '%H:%i')`,[currentTime1], (err, result) => {
                        flconnection.release();
                        if (err) {
                            console.log("Error querying shift times:", err);
                            return reject(err);
                        } else {
                            resolve(
                                result
                            );
                        }
                    });


                }
            });
        });
    };

    try {

        console.log("Centerline Cron Job Started");
        const karachiTime = moment().tz('Asia/Karachi');

        const currentDate = karachiTime.format('YYYY-MM-DD');
        const currentTime = karachiTime.format('HH:mm');
        console.log("Current Date in Karachi:", currentDate);
        console.log("Current Time in Karachi:", currentTime);


        const shiftTimes = await getShiftTimes();
        setShiftTimes(shiftTimes);

        console.log("Shift Times Centerline: ", shiftTimes)
        if (shiftTimes.length===0) {
            console.log("No data in ShiftTimes Centerline");
        } else {
            
            shiftTime= shiftTimes[0].shiftTime;
            shiftFrequency= shiftTimes[0].frequency
            console.log("Shift Time Centeline: ", shiftTime);
            console.log("Shift fre Centerline: ", shiftFrequency);
            
        }


        if (currentTime === "09:00" ) {
            pool.getConnection((err, connection) => {
                if (err) {
                    console.log("eror while creating connection", err);
                } else {
                    connection.query(`SELECT * FROM ${tableNames.centerline} Where dateToUpdate = ?`,[currentTime], (err, result) => {
                        connection.release();
                        if (err) {
                            console.log(err);   
                        } 
                        else {
                          
                            if (result.length > 0) {
                                result.forEach(item => {
                                    
                                    if (item.dateToUpdate === currentDate) {

                                        item.centerlineId= item.id;
                                        item.userStatus=0;
                                        let newid=item.id;
                                        delete item.id;
                                        item.date = currentDate;
                                        if (item.frequency === "Daily") {
                                            
                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                            item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            if (item.dateToUpdate.day() === 0) {
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            }
                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                        } 
                                        else if (item.frequency === "Weekly") {
                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                            item.dateToUpdate = item.dateToUpdate.add(1, 'weeks');
                                            if (item.dateToUpdate.day() === 0) {
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            }
                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                        } else if (item.frequency === "Bi-Weekly") {
                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                            item.dateToUpdate = item.dateToUpdate.add(2, 'weeks');
                                            if (item.dateToUpdate.day() === 0) {
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            }
                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                        } else if (item.frequency === "Monthly") {
                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                            item.dateToUpdate = item.dateToUpdate.add(1, 'months');
                                            if (item.dateToUpdate.day() === 0) {
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            }
                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                        } else if (item.frequency === "Quarterly") {
                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                            item.dateToUpdate = item.dateToUpdate.add(4, 'months');
                                            if (item.dateToUpdate.day() === 0) {
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            }
                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                        } else if (item.frequency === "Yearly") {
                                            item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                            item.dateToUpdate = item.dateToUpdate.add(1, 'years');
                                            if (item.dateToUpdate.day() === 0) {
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                            }
                                            item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                        } else {
                                            
                                        }

                                        if (item.frequency === "Daily"||item.frequency ==="Weekly"||item.frequency==="Monthly"||item.frequency==="Quarterly"||item.frequency==="Yearly"){
                                            const insertQuery = `INSERT INTO ${tableNames.feedback} SET ?`;
                                            connection.query(insertQuery, item, (insertError, insertResults) => {
                                                connection.release();
                                                if (insertError) {
                                                    console.error('Error inserting record:', insertError);
                                                    return;
                                                }
                                                console.log('Centerline Record Cron Successfully ==>:', item);
                                            });
                                            const updateQuery= `update ${tableNames.centerline} set dateToUpdate = ? where id = ?;`;
                                            connection.query(updateQuery, [item.dateToUpdate, newid], (updateError, updateResults) => {
                                                connection.release();
                                                if (updateError) {
                                                    console.error('Error inserting record:', insertError);
                                                    return;}
                                                console.log('Centerline Record Cron Update Successfully ==>:', item);
                                            });
                                            const currentlyActiveQuery = `update ${tableNames.feedback} set currentlyActive = 0 where date < ? and frequency = ?;`;
                                            connection.query(currentlyActiveQuery, [currentDate,item.frequency], (insertError, insertResults) => {
                                                connection.release();
                                                if (insertError) {
                                                    console.error('Error inserting record:', insertError);
                                                    return;
                                                }
                                               
                                            });
                                        }
                                    }
                                
                                });
                            } else {
                                console.log('No records found with frequency.');
                            }
                        }
                      
                    });

                }
            });            
        } 
        
        else if (currentTime ===shiftTime) {
            
            pool.getConnection((err, connection) => {
                if (err) {
                    console.log("eror while creating connection", err);
                } else {
                    connection.query(`SELECT * FROM ${tableNames.centerline} WHERE frequency = ? `, [shiftFrequency],(err, result) => {
                        connection.release();
                           
                        if (err) {
                            console.log(err);
                        } else {

                           
                            if (result.length > 0) {
                                result.forEach(item => {
                                    
                                    if (item.frequency === shiftFrequency) {
                                        

                                        item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                        item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                        if (item.dateToUpdate.day() === 0) {
                                            item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                        }
                                        item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD'); 
                                        item.centerlineId= item.id;
                                        item.userStatus=0;
                                        let newid=item.id;
                                        delete item.id;
                                        item.date = currentDate;
                                        
                                        
                                        const insertQuery = `INSERT INTO ${tableNames.feedback} SET ?`;
                                        connection.query(insertQuery, item, (insertError, insertResults) => {
                                            connection.release();
                                            if (insertError) {
                                                console.error('Error inserting record:', insertError);
                                                return;
                                            }
                                            
                                        });
                                        const updateQuery= `update ${tableNames.centerline} set dateToUpdate = ? where id = ?;`;
                                        connection.query(updateQuery, [item.dateToUpdate, newid], (updateError, updateResults) => {
                                            connection.release();
                                            if (updateError) {
                                                console.error('Error inserting record:', updateError);
                                                return;}
                                            console.log('Centerline Record Cron Update Successfully ==>:', item);
                                        });
                                        const currentlyActiveQuery = `update ${tableNames.feedback} set currentlyActive = 0 where date < ? and frequency= ?;`;
                                        connection.query(currentlyActiveQuery, [currentDate,shiftFrequency], (insertError, insertResults) => {
                                            connection.release();
                                            if (insertError) {
                                                console.error('Error inserting record:', insertError);
                                                return;
                                            }
                                        });
                                    }
                                });
                            } else {
                                console.log('No records found with frequency.');
                            }
                        }
                    });
                    
                }
            });
        } else {
            console.log("This is not shift time");
        }
         console.log("Centerline Cron Job Completed");
    } catch (err) {
    console.log("Cron Job Centerline (Catch): ", err.message);
   
    }
};

module.exports = { cloneRecordCenterline };