const express = require("express");
const router = express.Router();
const { GlobalUpdate } = require("../../GlobalFunctions/GlobalUpdate");
const tableName = require("../../Utils/allTableNames");
const RESPONSE = require("../../GlobalResponse/RESPONSE")

router.post("/updateUnits", (req, res) => {
  if (!req.body.id || !req.body.units) {
    return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
  }
  let payload = {
    id: req.body.id,
    tableName: tableName.units,
    databaseFields: {
      units: req.body.units,
    },
  };
  GlobalUpdate(payload, res);
});

module.exports = router;
