const express = require("express");
const router = express.Router();

// user authentication
const userAuth = require("../middleware/userAuth");

// Centerline
const createCenterline = require("../Apis/Centerline/Create");
const selectCenterline = require("../Apis/Centerline/Select");
const updateCenterline = require("../Apis/Centerline/Update");
const deleteCenterline = require("../Apis/Centerline/Delete");

// Fill Centerline
const createFillCenterline = require("../Apis/FillCenterline/Create");
const selectFillCenterline = require("../Apis/FillCenterline/Select");

// Centerline Items
const createCenterlineItems = require("../Apis/CenterlineItems/Create");
const selectCenterlineItems = require("../Apis/CenterlineItems/Select");
const updateCenterlineItems = require("../Apis/CenterlineItems/Update");

// Feedback
const createFeedback = require("../Apis/Feedback/Create");
const selectFeedback = require("../Apis/Feedback/Select");
const updateFeedback = require("../Apis/Feedback/Update");

// Email Configuration
const createEmailConfig = require("../Apis/emailConfiguration/Create");
const selectEmailConfig = require("../Apis/emailConfiguration/Select");
const updateEmailConfig = require("../Apis/emailConfiguration/Update");
const deleteEmailConfig = require("../Apis/emailConfiguration/Delete");

// Units
const createUnits = require("../Apis/Units/Create");
const selectUnits = require("../Apis/Units/Select");
const updateUnits = require("../Apis/Units/Update");
const deleteUnits = require("../Apis/Units/Delete");

//Acknowledgement 
const createAcknowledgement = require("../Apis/Acknowledgement/Create");
const selectAcknowledgement = require("../Apis/Acknowledgement/Select");
const updateAcknowledgement = require("../Apis/Acknowledgement/Update");


// authentication
const authentication = require("../Apis/Users/login");
// User
const createUser = require("../Apis/Users/Create");
const selectUser = require("../Apis/Users/Select");
const updateUser = require("../Apis/Users/Update");
const deleteUser = require("../Apis/Users/Delete");
const passwordReset = require("../Apis/Users/PasswordReset");

// Centerline
router.use("/api/centerline", createCenterline);
router.use("/api/centerline", selectCenterline);
router.use("/api/centerline", updateCenterline);
router.use("/api/centerline", deleteCenterline);

// Fill Centerline
router.use("/api/fillcenterline", createFillCenterline);
router.use("/api/fillcenterline", selectFillCenterline);

// Centerline Items
router.use("/api/centerlineItems", createCenterlineItems);
router.use("/api/centerlineItems", selectCenterlineItems);
router.use("/api/centerlineItems", updateCenterlineItems);

// Feedback
router.use("/api/feedback", createFeedback);
router.use("/api/feedback", selectFeedback);
router.use("/api/feedback", updateFeedback);

// Email Configuration
router.use("/api/emailconfig", createEmailConfig);
router.use("/api/emailconfig", selectEmailConfig);
router.use("/api/emailconfig", updateEmailConfig);
router.use("/api/emailconfig", deleteEmailConfig);

// Units
router.use("/api/units", createUnits);
router.use("/api/units", selectUnits);
router.use("/api/units", updateUnits);
router.use("/api/units", deleteUnits);

// Acknowledgement

router.use("/api/acknowledgement", createAcknowledgement);
router.use("/api/acknowledgement", selectAcknowledgement);
router.use("/api/acknowledgement", updateAcknowledgement);



module.exports = router;
