
const pool = require("../Utils/db");
const tableNames = require("../Utils/allTableNames");
const moment = require('moment-timezone');
const poolFl = require("../Utils/dbFl");

const cloneRecordTimeout =  async (req, res) => {

    const currentDate = moment();
    const karachiTime = moment().tz('Asia/Karachi');
    // console.log(karachiTime);
    // Separate the date and time
    // const currentDate = karachiTime.format('YYYY-MM-DD');
    const currentTime = karachiTime.format('HH:mm');

    const getFrequencyTime = () => {
        return new Promise((resolve, reject) => {
            poolFl.getConnection((err, flconnection) => {
                if (err) {
                    console.log("Error getting connection from poolFl:",err);
                    return reject(err);
                } else {
                    flconnection.query(
                        //`SELECT * FROM frequency WHERE ? >= STR_TO_DATE(shiftTime, '%H:%i') AND ? < STR_TO_DATE(shiftTimeEnd, '%H:%i')`,
                        //[currentTime, currentTime],
                        `SELECT * FROM frequency WHERE ? = STR_TO_DATE(timeOut, '%H:%i')`,[currentTime],
                        (err, result) => {
                            flconnection.release();
                            if (err) {
                                console.log("Error querying shift times:", err);
                                return reject(err);
                            } else {
                                resolve(result);
                            }
                        }
                    );
                }
            });
        });
    };  


    try {
        
        console.log("Timeout Cron Job Started");
        const frequencyTimeResult = await getFrequencyTime();
        console.log("Frequency Time Result:", frequencyTimeResult);

        const outTimes = frequencyTimeResult.map(item => item.timeOut);
        console.log("Shift Times:", outTimes);
        const shiftFrequency = frequencyTimeResult.map(item => item.frequency);
        console.log("Shift Times:", shiftFrequency);

        const frequencyList = shiftFrequency.map(freq => `'${freq}'`).join(',');
        console.log(frequencyList)

       const timeOut = outTimes[0]//shiftTimes.find((item) => currentTime === item)
       console.log(timeOut)

        if (currentTime === timeOut ) {
            console.log("in condition")

            pool.getConnection((err, connection) => {
                if (err) {
                    console.log("Error while connection (Cron Job Timeout): ", err.message);
                }
                connection.query(`SELECT * FROM ${tableNames.feedback} where userStatus = 0 AND frequency IN (${frequencyList})`, (err, result) => {
                    connection.release();
                    if (err) {
                        console.log("Error while Getting Data (Cron Job Timeout): ", err.message);
                    } else {
                        // console.log("Result: ", result); 
                        if (result.length > 0) {
                            result.forEach(item => {
                                const differenceOfDays = currentDate.diff(item.date, 'days');
                                // console.log("Difference Of Days", differenceOfDays);
                                if (differenceOfDays != 0) {
                                    //console.log("Time Out");
                                    connection.query(`UPDATE ${tableNames.feedback} SET userStatus = 2 WHERE id = ?`, item.id, (err, result) => {
                                        connection.release();
                                        if (err) {
                                            console.log("Error while Updating Data (Cron Job Timeout): ", err.message);
                                        } else {
                                            console.log("Result: ", result);    
                                     }
                                    });
                                  }
                                  else {
                                    console.log("Time not Out");
                                  }
                            });
                        } else {
                            console.log('No records found');
                        }
                    }
                }
            );
            });
        } 
        console.log("Timeout Cron Job Completed");
        } catch (err) {
        console.log("Cron Job Timeout (Catch): ", err.message);
        // return res.send(response(false, "Cron Job (Catch)", err.message));
        }
};

module.exports = { cloneRecordTimeout };


