const pool = require("../Utils/db");
const response = require("../GlobalResponse/RESPONSE");
const tableNames = require("../Utils/allTableNames");
const moment = require('moment-timezone');
const poolFl = require("../Utils/dbFl");
const { getShiftTimes } = require("../Utils/sharedShiftTimes");

const cloneRecordCenterlineItems = async (req, res) => {
    let shiftTime = ""
    let shiftFrequency = ""
  

    try {
        console.log("Centerline Items Cron Job Started");
        const karachiTime = moment().tz('Asia/Karachi');
        // Separate the date and time
        const currentDate = karachiTime.format('YYYY-MM-DD');
        const currentTime = karachiTime.format('HH:mm');
        karachiTimeNextDay = karachiTime.add(1, 'days');

        const shiftTimes = getShiftTimes();

        console.log("Shift Times Centerline Itmes: ", shiftTimes)
        if (shiftTimes.length===0) {
            console.log("No data in ShiftTimes Centerline Itmes: ");
        } else {
            
            shiftTime= shiftTimes[0].shiftTime;
            shiftFrequency= shiftTimes[0].frequency
            console.log("Shift Time CenterlineItems: ", shiftTime);
            console.log("Shift fre: CenterlineItems", shiftFrequency);
             
        }



        if (currentTime === "09:00") {
            

            pool.getConnection((err, connection) => {
                if (err) {
                    console.log("eror while creating connection", err);
                    
                } else {
                    connection.query(`SELECT * FROM ${tableNames.centerlineItems} where status = 1 and dateToUpdate = '${currentDate}'`, (err, result) => {
                        connection.release();
        
                        if (err) {
                            console.log(err);
                        } else {
                            
                            if (result.length > 0) {
                                result.forEach(item => {
                                    
                                    if (item.dateToUpdate == currentDate) {
                                            item.centerlineId= item.centerlineId;  
                                            let newid=item.id;
                                            delete item.id;
                                            item.date = currentDate;
                                            if (item.frequency === "Daily") {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                            } else if (item.frequency === "Weekly") {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'weeks');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                            } else if (item.frequency === "Bi-Weekly") {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(2, 'weeks');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                            } else if (item.frequency === "Monthly") {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'months');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                            } else if (item.frequency === "Quarterly") {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(4, 'months');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                            } else if (item.frequency === "Yearly") {
                                                item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                                item.dateToUpdate = item.dateToUpdate.add(1, 'years');
                                                if (item.dateToUpdate.day() === 0) {
                                                    item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                                }
                                                item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD');
                                            } else {
                                                
                                            }

                                            if (item.frequency === "Daily"||item.frequency ==="Weekly"||item.frequency==="Monthly"||item.frequency==="Quarterly"||item.frequency==="Yearly"){
                                            const insertQuery = `INSERT INTO ${tableNames.feedbackItems} SET ?`;
                                            connection.query(insertQuery, item, (insertError, insertResults) => {
                                                connection.release();
                                                if (insertError) {
                                                    console.error('Error inserting record:', insertError);
                                                    return;
                                                }
                                                console.log('Centerline ITEM Record Cron Successfully ===> :', item);
                                            });
                                            const updateQuery= `update ${tableNames.centerlineItems} set dateToUpdate = ? where id = ?;`;
                                            connection.query(updateQuery, [item.dateToUpdate, newid], (updateError, updateResults) => {
                                                connection.release();    
                                            if (updateError) {
                                                console.error('Error inserting record:', insertError);
                                                return;}
                                            console.log('Centerline  Item Record Cron Update Successfully ==>:', item);
                                            });
                                            const currentlyActiveQuery = `update ${tableNames.feedbackItems} set currentlyActive = 0 where date < ? and frequency = ?;`;
                                            connection.query(currentlyActiveQuery, [currentDate,item.frequency], (insertError, insertResults) => {
                                                connection.release();
                                                if (insertError) {
                                                    console.error('Error inserting record:', insertError);
                                                    return;
                                                }
                                                
                                            });
                                        } 
                                    }
                                });
                            } else {
                                console.log('No records found with frequency.');
                            }
                        }
                    });

                }
            });
        } 

        else if (currentTime ===shiftTime) {
            
            pool.getConnection((err, connection) => {
                if (err) {
                    console.log("eror while creating connection", err);
                    
                } else {

                    connection.query(`SELECT * FROM ${tableNames.centerlineItems} WHERE frequency = ? and status = 1` , [shiftFrequency],(err, result) => {
                        connection.release();
                           
                        if (err) {
                            console.log(err);
                        } else {
                           
                            if (result.length > 0) {
                                result.forEach(item => {
                                    if (item.frequency === shiftFrequency) {
                                        item.dateToUpdate = moment.tz(item.dateToUpdate, 'Asia/Karachi');
                                        item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                        if (item.dateToUpdate.day() === 0) {
                                            item.dateToUpdate = item.dateToUpdate.add(1, 'days');
                                        }
                                        item.dateToUpdate = item.dateToUpdate.format('YYYY-MM-DD'); 
                                        item.centerlineId= item.centerlineId;
                                        let newid=item.id;
                                        delete item.id;
                                        item.date = currentDate;
                                        const insertQuery = `INSERT INTO ${tableNames.feedbackItems} SET ?`;
                                        connection.query(insertQuery, item, (insertError, insertResults) => {
                                            connection.release();
                                            if (insertError) {
                                                console.error('Error inserting record:', insertError);
                                                return;
                                            }
                                            
                                        });
                                        const updateQuery= `update ${tableNames.centerlineItems} set dateToUpdate = ? where id = ?;`;
                                        connection.query(updateQuery, [item.dateToUpdate, newid], (updateError, updateResults) => {
                                            connection.release();
                                            if (updateError) {
                                                console.error('Error inserting record:', updateError);
                                                return;}
                                            console.log('CenterlineItems Record Cron Update Successfully ==>:', item);
                                        });
                                        const currentlyActiveQuery = `update ${tableNames.feedbackItems} set currentlyActive = 0 where date < ? and frequency= ?;`;
                                        connection.query(currentlyActiveQuery, [currentDate,shiftFrequency], (insertError, insertResults) => {
                                            connection.release();
                                            if (insertError) {
                                                console.error('Error inserting record:', insertError);
                                                return;
                                            }
                                            
                                        });
                                    }
                                });
                            } else {
                                console.log('No records found with frequency.');
                            }
                        }
                    });

                }
            });
        } else {
            console.log("This is not shift time");
        }
        console.log("Centerline Item Cron Job Completed");
    } catch (err) {
    console.log("Cron Job Centerline Item (Catch): ", err.message);
    
    }
};

module.exports = { cloneRecordCenterlineItems };



 








