const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/createEmailConfiguration", (req, res) => {
  try {
    if (!req.body.email || !req.body.area || !req.body.machine || !req.body.shift) {
      return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
    } 
    else {
      let payload = {
        tableName: tableName.emailConfiguration,
        databaseFields: {
          email: req.body.email,
          area: req.body.area,
          machine: req.body.machine,
          shift: req.body.shift
        },
      };
      GlobalInsert(payload, res);
    }   
  } catch (error) {
    return res.send(RESPONSE(false, "Email Configuration Create (Catch Error)", {}));
  }
});

module.exports = router;
