var express = require("express");
const router = express.Router();
const tableNames = require("../../Utils/allTableNames");
const pool = require("../../Utils/db");
const response = require("../../GlobalResponse/RESPONSE");

router.post("/createFillCenterline", (req, res) => {
    console.log("Req Body: ", req.body);

    if (!req.body.userId || !req.body.userName || !req.body.feedbackId  || !req.body.userStatus) {
    return res.status(400).send(response(false, "Please Fill All fields", {}));
    }
    
    req.body.userCenterLines.forEach((items) => {
        console.log(items);

        // Object.entries(items).forEach(([key, value]) => {
            // console.log("Key: ", key);
            // console.log("Value: ", value);


            let payload = {
                tableName: tableNames.fillCenterline,
                databaseFields: {
                    userId: req.body.userId,
                    userName: req.body.userName,
                    feedbackId: req.body.feedbackId,
                    userStatus: req.body.userStatus ,
                    submitDate: req.body.submitDate,
                    centerlineName: items.centerlineName,
                    userSubmitValue : items.submittedValue,
                },
            };

            pool.getConnection((err, connection) => {
                if (err) {
                  // console.log("eror while creating connection", err);
                  return res.send(reponse(false, "Database Connection Error", {}));
                }
                connection.query(`INSERT INTO ${payload.tableName} SET ?`, payload.databaseFields, (error, result) => {
                    connection.release();
                    if (error) {
                        console.log("Error From Items Tables", error);
                        return res.send(response(false, error.message, {}));
                    } else {
                        console.log("Items Inserted Successfully");

                    }
                });
                // connection.query(`UPDATE ${tableNames.centerline} set userStatus = ? where id = ?`, [req.body.userStatus,
                //     req.body.centerlineId], (error, result) => {
                //     connection.release();
                //     if (error) {
                //         console.log("Error From Items Tables", error);
                //         return res.send(response(false, error.message, {}));
                //     } else {
                //         console.log("Items Inserted Successfully", result);

                //     }
                // });
                connection.query(`UPDATE ${tableNames.feedback} set userStatus = ? where id = ?`, [req.body.userStatus,
                    req.body.feedbackId], (error, result) => {
                    connection.release();
                    if (error) {
                        console.log("Error From Items Tables", error);
                        return res.send(response(false, error.message, {}));
                    } else {
                        console.log("Items Inserted Successfully", result);

                    }
                });
            });
        });
        res.send(response(true, "succesfully added", {}));
    });


// });

module.exports = router;

