const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/createDepartments", (req, res) => {
  if (!req.body.department) {
    return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
  }
  let payload = {
    tableName: tableName.Departments,
    databaseFields: {
      department: req.body.department,
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
