const express = require("express");
const router = express.Router();
const { GlobalUpdate } = require("../../GlobalFunctions/GlobalUpdate");
const tableName = require("../../Utils/allTableNames");
const moment = require('moment-timezone');
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/updateAcknowledgement", (req, res) => {

  try {
    if (!req.body.id || !req.body.acknowledgeStatus) {
      return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
    } else {

      const karachiTime = moment().tz('Asia/Karachi');
      // console.log(karachiTime);
      // Separate the date and time
      const currentDate = karachiTime.format('YYYY-MM-DD');
      // console.log(req.body);
      console.log("ID: ", req.body.id);
      console.log("Acknowledged Status: ", req.body.acknowledgeStatus);
      console.log("Current Date: ", currentDate);
      let payload;
      if (req.body.acknowledgeStatus === 1) {
        console.log("Acknowledged By: ", req.body.acknowledgedBy);
        payload = {
          id: req.body.id,
          tableName: tableName.acknowledgementItems,
          databaseFields: {
            acknowledgeStatus: req.body.acknowledgeStatus,
            acknowledgedBy: req.body.acknowledgedBy,
            acknowledgedDate: currentDate
          }
        };
      } else if (req.body.acknowledgeStatus === 2) {
        console.log("Close By: ", req.body.closeBy);
        payload = {
          id: req.body.id,
          tableName: tableName.acknowledgementItems,
          databaseFields: {
            acknowledgeStatus: req.body.acknowledgeStatus,
            closeBy: req.body.closeBy,
            closeDate: currentDate
          },
        };
      } else {
        return res.send(RESPONSE(false, "Invalid Acknowledgement Status", {}));
      }
      GlobalUpdate(payload, res);
    }
  } catch (error) {
    return res.send(RESPONSE(false, "Update Acknowledgement (Catch Error)", error.message));
  }
  
});

module.exports = router;
